/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.client.util.SafeImageExtraction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Overlay
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<NativeImage> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        ArrayList<Supplier<NativeImage>> inputs = new ArrayList<Supplier<NativeImage>>();
        for (JsonObject o : locationSource.inputs) {
            inputs.add(DynamicTextureJson.readSupplierFromSource(o));
        }
        return () -> {
            int maxX = 0;
            int maxY = 0;
            List<NativeImage> images = inputs.stream().map(Supplier::get).toList();
            for (int i = 0; i < images.size(); ++i) {
                if (images.get(i) != null) continue;
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.inputs.get(i).toString());
                return null;
            }
            for (NativeImage image : images) {
                if (image.m_84982_() <= maxX) continue;
                maxX = image.m_84982_();
                maxY = image.m_85084_();
            }
            try (MultiCloser multiCloser = new MultiCloser(images);){
                NativeImage output = NativeImageHelper.of(NativeImage.Format.RGBA, maxX, maxY, false);
                NativeImage base = images.get(0);
                int xs = 1;
                int ys = 1;
                if ((double)base.m_84982_() / ((double)base.m_85084_() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                    xs = maxX / base.m_84982_();
                    ys = maxY / base.m_84982_();
                } else {
                    xs = maxX / base.m_85084_();
                    ys = maxY / base.m_85084_();
                }
                for (int x = 0; x < maxX; ++x) {
                    for (int y = 0; y < maxY; ++y) {
                        output.m_84988_(x, y, SafeImageExtraction.get(base, x / xs, y / ys));
                    }
                }
                if (images.size() >= 2) {
                    for (int i = 1; i < images.size(); ++i) {
                        NativeImage image = images.get(i);
                        if ((double)image.m_84982_() / ((double)image.m_85084_() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                            xs = maxX / image.m_84982_();
                            ys = maxY / image.m_84982_();
                        } else {
                            xs = maxX / image.m_85084_();
                            ys = maxY / image.m_85084_();
                        }
                        for (int x = 0; x < maxX; ++x) {
                            for (int y = 0; y < maxY; ++y) {
                                ColorHolder input = ColorHolder.fromColorInt(SafeImageExtraction.get(output, x, y));
                                ColorHolder top = ColorHolder.fromColorInt(SafeImageExtraction.get(image, x / xs, y / ys));
                                ColorHolder outColor = ColorHolder.alphaBlend(top, input);
                                output.m_84988_(x, y, ColorHolder.toColorInt(outColor));
                            }
                        }
                    }
                }
                NativeImage nativeImage = output;
                return nativeImage;
            }
        };
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        public List<JsonObject> inputs;
    }

    public static class MultiCloser
    implements AutoCloseable {
        private final List<? extends AutoCloseable> toClose;

        public MultiCloser(List<? extends AutoCloseable> toClose) {
            this.toClose = toClose;
        }

        @Override
        public void close() {
            for (AutoCloseable autoCloseable : this.toClose) {
                try {
                    autoCloseable.close();
                }
                catch (Exception e) {
                    DynamicAssetGenerator.LOGGER.error("Exception while closing resources:\n", (Throwable)e);
                }
            }
        }
    }
}

